Ext.data.JsonP.sol_common_XmlBuilder({"tagname":"class","name":"sol.common.XmlBuilder","autodetected":{"aliases":true,"alternateClassNames":true,"extends":true,"mixins":true,"requires":true,"uses":true,"members":true,"code_type":true},"files":[{"filename":"lib_sol.common.XmlUtils.js","href":"lib_sol.common.XmlUtils.html#sol-common-XmlBuilder"}],"private":true,"aliases":{},"alternateClassNames":[],"extends":"sol.Base","mixins":[],"requires":[],"uses":[],"members":[{"name":"initialize","tagname":"cfg","owner":"sol.common.XmlBuilder","id":"cfg-initialize","meta":{}},{"name":"requiredConfig","tagname":"cfg","owner":"sol.Base","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"logger","tagname":"property","owner":"sol.Base","id":"property-logger","meta":{"protected":true}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"addElement","tagname":"method","owner":"sol.common.XmlBuilder","id":"method-addElement","meta":{}},{"name":"buildFromJson","tagname":"method","owner":"sol.common.XmlBuilder","id":"method-buildFromJson","meta":{}},{"name":"createXml","tagname":"method","owner":"sol.common.XmlBuilder","id":"method-createXml","meta":{}},{"name":"getFirstPropName","tagname":"method","owner":"sol.common.XmlBuilder","id":"method-getFirstPropName","meta":{"private":true}},{"name":"getNamespaceUri","tagname":"method","owner":"sol.common.XmlBuilder","id":"method-getNamespaceUri","meta":{}},{"name":"getXmlDoc","tagname":"method","owner":"sol.common.XmlBuilder","id":"method-getXmlDoc","meta":{}},{"name":"initialize","tagname":"method","owner":"sol.Base","id":"method-initialize","meta":{"private":true}},{"name":"processObj","tagname":"method","owner":"sol.common.XmlBuilder","id":"method-processObj","meta":{"private":true}},{"name":"toString","tagname":"method","owner":"sol.common.XmlBuilder","id":"method-toString","meta":{}}],"code_type":"ext_define","id":"class-sol.common.XmlBuilder","classIcon":"icon-class","superclasses":["sol.Base"],"subclasses":[],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><strong>sol.common.XmlBuilder</strong></div></div><h4>Files</h4><div class='dependency'><a href='source/lib_sol.common.XmlUtils.html#sol-common-XmlBuilder' target='_blank'>lib_sol.common.XmlUtils.js</a></div></pre><div class='doc-contents'><div class='rounded-box private-box'><p><strong>NOTE:</strong> This is a private utility class for internal use by the framework. Don't rely on its existence.</p></div><p>XML builder</p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-initialize' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.XmlBuilder'>sol.common.XmlBuilder</span><br/><a href='source/lib_sol.common.XmlUtils.html#sol-common-XmlBuilder-cfg-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.XmlBuilder-cfg-initialize' class='name expandable'>initialize</a> : org.w3c.dom.Document<span class=\"signature\"></span></div><div class='description'><div class='short'><p>XML document</p>\n</div><div class='long'><p>XML document</p>\n</div></div></div><div id='cfg-requiredConfig' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-logger' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-logger' class='name expandable'>logger</a> : <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a><span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Logger for this class instance. ...</div><div class='long'><p>Logger for this class instance. This logger is created by <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a>.</p>\n\n<p>Please see <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a> class documentation for more information.</p>\n<p>Overrides: <a href=\"#!/api/sol.common.ix.FunctionBase-property-logger\" rel=\"sol.common.ix.FunctionBase-property-logger\" class=\"docClass\">sol.common.ix.FunctionBase.logger</a>, <a href=\"#!/api/sol.common.ix.ServiceBase-property-logger\" rel=\"sol.common.ix.ServiceBase-property-logger\" class=\"docClass\">sol.common.ix.ServiceBase.logger</a></p></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-addElement' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.XmlBuilder'>sol.common.XmlBuilder</span><br/><a href='source/lib_sol.common.XmlUtils.html#sol-common-XmlBuilder-method-addElement' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.XmlBuilder-method-addElement' class='name expandable'>addElement</a>( <span class='pre'>parentElement, tagName, content, attribObj</span> ) : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>Adds an element to the XML document ...</div><div class='long'><p>Adds an element to the XML document</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>parentElement</span> : org.w3c.dom.Node<div class='sub-desc'><p>Parent element.</p>\n</div></li><li><span class='pre'>tagName</span> : String<div class='sub-desc'><p>Tag name of the new element.</p>\n</div></li><li><span class='pre'>content</span> : String<div class='sub-desc'><p>Content of the new element.</p>\n</div></li><li><span class='pre'>attribObj</span> : Object<div class='sub-desc'><p>Attributes of the new element as map.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>newElement element to the XML document.</p>\n</div></li></ul></div></div></div><div id='method-buildFromJson' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.XmlBuilder'>sol.common.XmlBuilder</span><br/><a href='source/lib_sol.common.XmlUtils.html#sol-common-XmlBuilder-method-buildFromJson' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.XmlBuilder-method-buildFromJson' class='name expandable'>buildFromJson</a>( <span class='pre'>data, dataDefintion</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Creates a new XML document by JavaScript object ...</div><div class='long'><p>Creates a new XML document by JavaScript object</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>data</span> : Object<div class='sub-desc'><p>Data object that contains the data that should be converted into XML</p>\n</div></li><li><span class='pre'>dataDefintion</span> : Object<div class='sub-desc'><p>Definition object that contains meta information for the transformation.</p>\n</div></li></ul></div></div></div><div id='method-createXml' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.XmlBuilder'>sol.common.XmlBuilder</span><br/><a href='source/lib_sol.common.XmlUtils.html#sol-common-XmlBuilder-method-createXml' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.XmlBuilder-method-createXml' class='name expandable'>createXml</a>( <span class='pre'>rootTagName, attribObj</span> ) : org.w3c.dom.Document<span class=\"signature\"></span></div><div class='description'><div class='short'>Creates a new XML document ...</div><div class='long'><p>Creates a new XML document</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>rootTagName</span> : String<div class='sub-desc'><p>Name of the root element.</p>\n</div></li><li><span class='pre'>attribObj</span> : Array<div class='sub-desc'><p>Attributes of the root element.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>org.w3c.dom.Document</span><div class='sub-desc'><p>Created XML document.</p>\n</div></li></ul></div></div></div><div id='method-getFirstPropName' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.XmlBuilder'>sol.common.XmlBuilder</span><br/><a href='source/lib_sol.common.XmlUtils.html#sol-common-XmlBuilder-method-getFirstPropName' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.XmlBuilder-method-getFirstPropName' class='name expandable'>getFirstPropName</a>( <span class='pre'>obj</span> ) : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Returns the first property of an object. ...</div><div class='long'><p>Returns the first property of an object.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>obj</span> : Object<div class='sub-desc'><p>Data object that contains the data that should be converted into XML</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>prop.</p>\n</div></li></ul></div></div></div><div id='method-getNamespaceUri' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.XmlBuilder'>sol.common.XmlBuilder</span><br/><a href='source/lib_sol.common.XmlUtils.html#sol-common-XmlBuilder-method-getNamespaceUri' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.XmlBuilder-method-getNamespaceUri' class='name expandable'>getNamespaceUri</a>( <span class='pre'>node</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the namespace ...</div><div class='long'><p>Returns the namespace</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>node</span> : org.w3c.dom.Node<div class='sub-desc'><p>Node</p>\n</div></li></ul></div></div></div><div id='method-getXmlDoc' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.XmlBuilder'>sol.common.XmlBuilder</span><br/><a href='source/lib_sol.common.XmlUtils.html#sol-common-XmlBuilder-method-getXmlDoc' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.XmlBuilder-method-getXmlDoc' class='name expandable'>getXmlDoc</a>( <span class='pre'></span> ) : org.w3c.dom.Document<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the root element of the XML document. ...</div><div class='long'><p>Returns the root element of the XML document.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>org.w3c.dom.Document</span><div class='sub-desc'><p>XML document</p>\n</div></li></ul></div></div></div><div id='method-initialize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Initialize class. ...</div><div class='long'><p>Initialize class.\nThis function is called after the class was instantiated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>parameters as defined. See documentation for more details.</p>\n\n</div></li></ul><p>Overrides: <a href=\"#!/api/sol.common.ix.FunctionBase-method-initialize\" rel=\"sol.common.ix.FunctionBase-method-initialize\" class=\"docClass\">sol.common.ix.FunctionBase.initialize</a></p></div></div></div><div id='method-processObj' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.XmlBuilder'>sol.common.XmlBuilder</span><br/><a href='source/lib_sol.common.XmlUtils.html#sol-common-XmlBuilder-method-processObj' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.XmlBuilder-method-processObj' class='name expandable'>processObj</a>( <span class='pre'>obj, parentElement</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Recursive method that converts JavaScript object elements to XML ...</div><div class='long'><p>Recursive method that converts JavaScript object elements to XML</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>obj</span> : Object<div class='sub-desc'><p>Data object that contains the data that should be converted into XML</p>\n</div></li><li><span class='pre'>parentElement</span> : org.w3c.dom.Document<div class='sub-desc'><p>XML document.</p>\n</div></li></ul></div></div></div><div id='method-toString' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.XmlBuilder'>sol.common.XmlBuilder</span><br/><a href='source/lib_sol.common.XmlUtils.html#sol-common-XmlBuilder-method-toString' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.XmlBuilder-method-toString' class='name expandable'>toString</a>( <span class='pre'></span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Renders the XML document as string ...</div><div class='long'><p>Renders the XML document as string</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>XML document as string.</p>\n</div></li></ul></div></div></div></div></div></div></div>","meta":{"private":true}});